#ifndef POLLUXD_ROUTE_H__
#define POLLUXD_ROUTE_H__

#include <libpxd/px_route.h>

enum polluxd_action {
  POLLUXD_DO_DENY = 0,
  POLLUXD_DO_FILE,
  POLLUXD_DO_CGI,
  POLLUXD_DO_PIPE,
  POLLUXD_N_ACTIONS
};

struct polluxd_route_data {
  enum polluxd_action action;
  unsigned            strip;
  struct px_path      prefix;
  _Bool               autoindex;
  _Bool               require_cert;
  char*               allowed_cert_file;
  char*               index_file;
  char*               cgi_user;
  char*               cgi_group;
  char*               cgi_chroot;
  char*               cgi_docroot;
  char*               cgi_script;
  int                 cgi_helper_sock;
};

struct px_path polluxd_translate_path(struct px_path const* path,
                                      unsigned strip,
                                      struct px_path const* prefix);
void polluxd_route_data_init(struct polluxd_route_data* rtd);
void polluxd_route_data_reset(struct polluxd_route_data* rtd);

//px_op_status polluxd_route_request(struct px_gemini_context* gemctx);

#endif // POLLUXD_ROUTE_H__
