#include <polluxd.h>
#include <polluxd_route.h>
#include <libpxd/px_log.h>
#include <libpxd/px_route.h>
#include <unistd.h>

struct px_path polluxd_translate_path(struct px_path const* path,
                                      unsigned strip,
                                      struct px_path const* prefix)
{
  px_log_assert(path != NULL, "path should never be null");

  // strip leading components of path and prepend the prefix
  struct px_path stripped = px_path_strip_leading(path, strip);
  struct px_path translated = px_path_concat_consume1(prefix, &stripped);

  // make sure it's absolute
  if (!px_path_make_abs(&translated))
    px_log_fatal("no memory");

  return translated;
}

void polluxd_route_data_init(struct polluxd_route_data* rtd) {
  *rtd = (struct polluxd_route_data) { 0 };
  rtd->cgi_helper_sock = -1;
}

void polluxd_route_data_reset(struct polluxd_route_data* rtd) {
  if (!rtd)
    return;

  px_path_reset(&rtd->prefix);
  free(rtd->index_file);
  free(rtd->allowed_cert_file);
  free(rtd->cgi_user);
  free(rtd->cgi_group);
  free(rtd->cgi_chroot);
  free(rtd->cgi_docroot);
  free(rtd->cgi_script);

  if (rtd->cgi_helper_sock >= 0)
    close(rtd->cgi_helper_sock);

  polluxd_route_data_init(rtd);
}
