#ifndef POLLUXD_CONFIG_H__
#define POLLUXD_CONFIG_H__

#include <libpxd/px_common.h>
#include <stdio.h>

#define POLLUXD_MAX_ROUTE_ACTIONS 32

struct polluxd_config_location {
  struct polluxd_config_location* next;

  // the request path that should be matched
  char*     path;

  // the configuration-settable pieces
  char*     prefix;
  unsigned  strip;
  char*     action;
  char*     cgi_user;
  char*     cgi_group;
  char*     cgi_chroot;
  char*     cgi_docroot; // not used
  char*     cgi_script;
  _Bool     autoindex;
  _Bool     require_cert;
  char*     allowed_cert_file;
  char*     index_file;
};

struct polluxd_config {
  // frequently accessed, put it at the front
  struct polluxd_config_location* locations;

  char* host;
  char* listen_addr;
  char* port;
  char* cert_file;
  char* key_file;
  char* docroot;
  _Bool autoindex;
  char* default_index_file;
  char* chroot_dir;
  char* drop_user;
  char* drop_group;
  char* logfile;
  _Bool foreground;
};

void polluxd_config_reset(struct polluxd_config* conf);

int polluxd_config_read_file(struct polluxd_config* conf, FILE* cfile, char const* conf_filename);

#endif // POLLUXD_CONFIG_H__
