#ifndef PX_WORKQ_H__
#define PX_WORKQ_H__

#include <libpxd/px_event.h>

struct pollfd_vec {
  struct pollfd*  pfds;
  size_t          pfds_sz;
};

struct px_workq {
  struct px_queue         events_head;
  struct pollfd_vec       pfd_vec;
};

void px_workq_init(struct px_workq* workq);
void px_workq_reset(struct px_workq* workq);
_Bool px_workq_is_empty(struct px_workq const* workq);

// do one loop through the event queue
_Bool px_workq_once(struct px_workq* workq, int timeout);

#endif // PX_WORKQ_H__
