#ifndef PX_PATH_H__
#define PX_PATH_H__

#include <stddef.h>
#include <stdbool.h>

// for a gemini request the maximum number of (valid) path elements will be 512
// "./"*512 is 1024 bytes which is the max gemini request length.  we don't
// need to handle more than that
#define PX_PATH_MAX_COMPONENTS 512

struct px_path {
  char** components;
  size_t components_sz;
};

void            px_path_init(struct px_path* path);
void            px_path_reset(struct px_path* path);
_Bool           px_path_is_valid(struct px_path const* path);
struct px_path  px_path_copy(struct px_path const* src);
void            px_path_move(struct px_path* dst, struct px_path* src);
struct px_path  px_path_strip_leading(struct px_path const* src, unsigned n);
struct px_path  px_path_from_str(char const* str);
struct px_path  px_path_from_str_clean(char const* str);
struct px_path  px_path_clean(struct px_path const* path);
char*           px_path_to_str(struct px_path const* path);
struct px_path  px_path_concat(struct px_path const* pre, struct px_path const* suf);

// consume calls px_path_reset on pre and suf
struct px_path  px_path_concat_consume(struct px_path* pre, struct px_path* suf);
// consume0 calls px_path_reset on pre
struct px_path  px_path_concat_consume0(struct px_path* pre, struct px_path const* suf);
// consume1 calls px_path_reset on suf
struct px_path  px_path_concat_consume1(struct px_path const* pre, struct px_path* suf);

struct px_path  px_path_concat_clean(struct px_path const* pre, struct px_path const* suf);
char const*     px_path_get_component(struct px_path const* path, int comp);
_Bool           px_path_is_abs(struct px_path const* path);
_Bool           px_path_make_abs(struct px_path* path);
_Bool           px_path_make_rel(struct px_path* path);

#endif // PX_PATH_H__
