#ifndef PX_LISTENER_H__
#define PX_LISTENER_H__

#include <libpxd/px_network.h>
#include <stdbool.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netdb.h>

#define GEMINI_PORT 1965

struct px_listen_socket {
  int     fd;
  char    host_str[PX_ADDRSTR_LEN];
};

// this updates the host_str member of a px_listen_socket to reflect the host
// socket name of fd (i.e. if is valid)
void px_listen_socket_update_addrstr(struct px_listen_socket* lsn);

// these return file descriptors
int px_bind(char const* listen_addr, char const* host, char const* port);
int px_bind_inet4(in_addr_t addr, in_port_t port);
int px_bind_unix(char const* path);
int px_bind_addrinfo(struct addrinfo const* ai);

#endif // PX_LISTENER_H__
