/*********************************************************************

ShadLink.c

Requires PalmOS 3.1
For OS 3.0, un-comment #include <TxtGlue.h>, change romVersion to 0x03003000 and
change all Txt* fcns to TxtGlue* fcns

Ver 1.2
- Removed use of SHAD_LOCK

Ver 1.1
- Fix a mixup between cardNo and cmdPBP->dbCardNo which led to barfing
when ShadowPlan is not in RAM

ver 1.0
- First public release

ver 1.0b2
- Fixed when Field has no text length

Ver 1.0a4
- Don't barf on ']' in list name

Ver 1.0a3
- Brute force double-tap for OS 3.5 too

Ver 1.0a2
- Configuable activation

Ver 1.0a1
- Implement double-tapping for pre 3.5 OS compatibility

Copyright (C) 2002 Ling Nero
 
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

RnLNero@yahoo.com

 ********************************************************************/

#include <PalmOS.h>
#include <SysEvtMgr.h>
#include <Standalone.h>
// #include <TxtGlue.h>
#include "shadlink.h"

static void Beep(UInt16, UInt16);
static Boolean DoAction(FieldPtr);
static Boolean CloseEnough(UInt32, UInt32, UInt32, UInt32);

typedef struct {
	Int16 trigger;
} ShadLinkPrefType;

HACKMASTER_TRAP (0xA13B);
STANDALONE_CODE_RESOURCE_ID (1000);

Boolean ShadowLink(FieldPtr fldP, EventPtr eventP)
{
	Boolean (*oldtrap) (FieldPtr, EventPtr);
	UInt32 temp, romVersion, screenX, screenY;
	ShadLinkPrefType pref;
	UInt16 prefSize;
	Boolean handled;
	
	handled=false;

	FtrGet(SPLK_CRID,SPLK_RSID,&temp);
	oldtrap=(Boolean (*)(FieldPtr,EventPtr))temp;

	/* what's the trigger? */

	prefSize = sizeof(ShadLinkPrefType);
	if (PrefGetAppPreferences(SPLK_CRID, 1, &pref, &prefSize, true) == noPreferenceFound)
	{
		pref.trigger = pushID_DoubleTap;
		PrefSetAppPreferences(SPLK_CRID,1,1,&pref,sizeof(pref),true);
	}

	FtrGet(sysFtrCreator, sysFtrNumROMVersion, &romVersion);
	
	if (romVersion >= 0x03103000)
	{
		switch (pref.trigger)
		{
			case pushID_DoubleTap :
				if (romVersion > 0x03503000)
				{
					if (eventP->eType == penDownEvent && eventP->tapCount == 2)
					{
//						Beep(1,sndStartUp);
						handled = DoAction(fldP);
					}
				}
				else // pre OS3.5
				{
					if (eventP->eType == penDownEvent)
					{
						if (!FtrGet(SPLK_CRID,TAP_SCREEN_X,&screenX) && !FtrGet(SPLK_CRID,TAP_SCREEN_Y,&screenY)) // set
						{
							if (CloseEnough(eventP->screenX,screenX,eventP->screenY,screenY))
							{
//								Beep(1,sndStartUp);
								handled = DoAction(fldP);
							}
						}
						FtrSet(SPLK_CRID,TAP_SCREEN_X,eventP->screenX);
						FtrSet(SPLK_CRID,TAP_SCREEN_Y,eventP->screenY);
					}
				}
				break;

			case pushID_SingleTap :
					if (eventP->eType == fldEnterEvent)
					{
						oldtrap(fldP,eventP);
						DoAction(fldP);
						handled = true; // FldHandleEvent already done
					}
					break;

			default: break;
		}

	}

end:
	if (!handled)
		handled=oldtrap(fldP,eventP);
	
	return handled;
}

static Boolean CloseEnough(UInt32 tapX, UInt32 lastTapX, UInt32 tapY, UInt32 lastTapY)
{
	UInt32 diffX, diffY;
	
	diffX = (tapX > lastTapX)?(tapX-lastTapX):(lastTapX-tapX);
	diffY = (tapY > lastTapY)?(tapY-lastTapY):(lastTapY-tapY);

	if (diffX <= 5 && diffY <= 5)
		return true;
	else return false;
}

static Boolean DoAction(FieldPtr fP)
{
	LocalID dbID;
	UInt32 uniqueID, outStart, outEnd;
	UInt16 cardNo, cursor, tagLen, fLen, i, j, k, cliplength, startPos, endPos, attrP;
	MemHandle fTextH, resH;
	MemPtr fTextP, clipP, resP, listName;
	Char ShadowTag[20], *strP, *listNameP;
	DmOpenRef refDB;
	GoToParamsType *cmdPBP;
	DmSearchStateType stateInfoP;

	fTextH = NULL;
	cmdPBP = NULL;

	if (fP == NULL)
		goto cleanup;

	refDB=DmOpenDatabaseByTypeCreator('HACK',SPLK_CRID,dmModeReadOnly);
	if (!refDB)
		goto cleanup;

	resH = DmGet1Resource(strRsc, 2000);
	resP = MemHandleLock(resH);
	StrCopy(ShadowTag,resP);
	MemHandleUnlock(resH);
	DmReleaseResource(resH);
	DmCloseDatabase(refDB);

	/* get a chunk of the text around cursor */
	tagLen = StrLen(ShadowTag);
	fLen = FldGetTextLength(fP);
	if (fLen <= tagLen)
		goto cleanup;

	cmdPBP = (GoToParamsType *) MemPtrNew(sizeof(GoToParamsType));
	if (!cmdPBP)
		goto cleanup;

	cursor = FldGetInsPtPosition(fP);
	if (cursor <= tagLen)
		startPos = 0;
	else startPos = cursor - tagLen;
	endPos = cursor + tagLen;
	if (endPos > fLen-1)
		endPos = fLen-1;

	clipP = FldGetTextPtr(fP);
	strP = (char *)clipP;
	TxtCharBounds(strP, startPos, &outStart, &outEnd);
	startPos = outStart;
	TxtCharBounds(strP, endPos, &outStart, &outEnd);
	endPos = outEnd;

	cliplength = endPos - startPos + 1;
	fTextH = MemHandleNew(cliplength+1);
	if (!fTextH)
		goto cleanup;

	fTextP = MemHandleLock(fTextH);

	strP += startPos;
	MemMove(fTextP, (void *)strP, cliplength);

	strP = (char *)fTextP;
	strP[cliplength] = NULL;

	if (cliplength >= tagLen)
	for (i=0; i<=cliplength-tagLen && cursor >= startPos+i; i += TxtNextCharSize(strP,i))
	{
		if (TxtCompare(&strP[i], tagLen, NULL, ShadowTag, tagLen, NULL) == 0)
		{
//				Beep(1,sndWarning);

				/* Extract information to set up cmdPBP */

				startPos += i; 					// set to first '['
				startPos += tagLen;				// skip tag and point to '('
				endPos = fLen;

				/* get the rest of the tag */
				cliplength = endPos - startPos + 1;
				clipP = FldGetTextPtr(fP);
				MemHandleUnlock(fTextH);
				if (MemHandleResize(fTextH, cliplength+1))
					goto cleanup;

				fTextP = MemHandleLock(fTextH);
				strP = (char *)clipP;
				strP += startPos;
				MemMove(fTextP, (void *)strP, cliplength);
				strP = (char *)fTextP;
				strP[cliplength] = NULL;

				uniqueID = 0;

				/* Extract uniqueID */
				if (strP[0] == '(')
				{
					for (i=1; strP[i] != ')' && strP[i] != NULL; i++)
						if (strP[i] < '0' || strP[i] > '9') // bad uniqueID
							goto cleanup;

					if (strP[i] == NULL)			// bad form
						goto cleanup;
						
					for (j=1; j<i; j++)
						uniqueID = uniqueID * 10 + (strP[j] - '0');

					/* strP[i] shound be ')', so skip ahead 2 */
					i += 2;
				}
				else i=0;
					
				/* Extract list name */
				/* skip to end of list name */
				j=i;

extract:
				for (; strP[j] != '>' && strP[j] != ']' && strP[j] != NULL; j += TxtNextCharSize(strP,j));

				if (strP[j] == NULL)			// uh-oh, bad form
					goto cleanup;

				if (strP[j] == ']')				// make sure ']' is not part of the file name
				{
					for (k=0; strP[j+k] == ']' && strP[j+k] != NULL; k += TxtNextCharSize(strP,j+k));

					if (k < 3) // don't have ']]]'
					{
						j= j+k;
						goto extract;
					}
					if (k > 3)
						j = j+k-3;
				}

				if (strP[j] == '>')				// need to get rid of trailing space
					j--;

				j--;
				listName = MemPtrNew(j-i+8);
				if (!listName)
					goto cleanup;
				listNameP = (char *)listName;
				StrCopy(listNameP, "ShadP-");
				StrNCopy(&listNameP[6], &strP[i], j-i+1);
				listNameP[6+j-i+1] = NULL;

				/* Find list */
				cmdPBP->dbCardNo=0;
				cmdPBP->dbID = DmFindDatabase(0,listNameP);
				MemPtrFree(listName);

				if (cmdPBP->dbID == 0) // it doesn't exist
					goto cleanup;

				/* Find Shadow */
				if (DmGetNextDatabaseByTypeCreator(true, &stateInfoP,'appl','Coog',true,&cardNo,&dbID) != errNone)
					goto cleanup;

				if (uniqueID != 0)
				{
					/* open list */
					refDB = DmOpenDatabase(cmdPBP->dbCardNo,cmdPBP->dbID,dmModeReadOnly);
					if (!refDB)
						goto cleanup;

					/* find record by uniqueID */
					if (DmFindRecordByID(refDB, uniqueID, &(cmdPBP->recordNum)) != 0)
					{
						cmdPBP->recordNum = 1;
						attrP=0;
					}
					/* check if record is not deleted */
					else DmRecordInfo(refDB, cmdPBP->recordNum, &attrP, NULL, NULL);
					DmCloseDatabase(refDB);

					if (attrP & dmRecAttrDelete)
						goto cleanup;
				}
				else cmdPBP->recordNum = 1;

				cmdPBP->matchFieldNum=cmdPBP->recordNum-1;
				cmdPBP->matchPos = 0;
				cmdPBP->matchCustom = 0;
				cmdPBP->searchStrLen=0;

				MemHandleUnlock(fTextH);
				MemHandleFree(fTextH);

				MemPtrSetOwner(cmdPBP, 0);
						
				SysUIAppSwitch(cardNo, dbID, sysAppLaunchCmdGoTo,cmdPBP);
				return 1;
		}
	}

cleanup:

	if (fTextH)
	{
		MemHandleUnlock(fTextH);
		MemHandleFree(fTextH);
	}
	if (cmdPBP)
		MemPtrFree(cmdPBP);

	return 0;
}

void Beep(UInt16 times,UInt16 type)
{
	UInt16 i;

	for (i=0; i<times; i++)
		SndPlaySystemSound(type);
}
