Attribute VB_Name = "NewMacros12"
Sub ExporttoXML()
'
' Main
' Exports currently open MS DOC file as an XML formatted file which can be opened by
' Shadow desktop.
' VERSION: 1.0   18th Jan 2003 (c) Victor Jones
' USAGE: Can be freely distributed.  Any modifications should be notified to the author if they are made public.
' Acknowledgements: To the glory of God.  Philippians 4:13 - I can do all things through Christ which strengtheneth me.
' KNOWN PROBLEMS:  File save in Extended ASCII format
' REVISION HISTORY:
'   V1.0 -Fixed problem saving to UTF-8 - switched to ISO-8859-1 which
'          now allows extended characters e.g degree symbol, MegaWiki dot (Alt-0183) etc.
'        -Recognises bold text
'        -Sets complete flag for struckthrough items
'
'PSEUDOCODE:
'   Open 'file' for output
'   Write header lines
'   Check level of and write out each Para
'   Write footer lines
'   Convert to plain text
'   Write output to .XML file
'

    Dim currPara As Long
    Dim MyOutput As Document
    Dim SourceDoc As Document
    Dim TempDoc As Document

' Store name of current doc
    If Documents.Count >= 1 Then
        Set SourceDoc = ActiveDocument
    Else
        MsgBox "No documents are open"
    End If
    
' Create new unnamed temporary doc (in memory) so that input doc remains unchanged
    Selection.WholeStory
    Selection.Copy
    Set TempDoc = Documents.Add         'DocumentType:=wdNewBlankDocument
    Selection.Paste

 '    Application.Documents.Open FileName:="C:\Documents and Settings\MYOUTPUT.DOC"
' Create new unnamed doc (in memory) for output
    Set MyOutput = Documents.Add
    Set Insertpnt = MyOutput.Range(Start:=0, End:=0)

  
' Following 2 lines can be uncommented/adapted if a specific file is required to be opened
' as the source doc.  e.g. File open dialogue could be invoked if reqd.
' Default is to reactivate file which was open when procedure called, as source doc
'    Application.Documents.Open FileName:="C:\Documents and Settings\MYINPUT.DOC"
'    Windows("MYINPUT.DOC").Activate
    
    SourceDoc.Activate      'Reactivate original doc
    If ActiveDocument.Saved = False Then
        Style = vbOKOnly + vbExclamation                    ' Define buttons.
        Title = "DOC File has not previously been saved"    ' Define title.
        Msg = "Click OK then Save file - output will be put in same directory"
        MsgBox Msg, Style, Title
        ActiveDocument.Save
    End If
        
    TempDoc.Activate      'Reactivate input
    ReplaceXMLreserved FileName:=TempDoc

' Sort out MS Word oddities
    If TempDoc.Tables.Count >= 1 Then
        For Each ttable In TempDoc.Tables
            ttable.ConvertToText Separator:=wdSeparateByTabs
        Next
    End If

    ActiveDocument.ActiveWindow.View.Type = wdNormalView   'Must not be in outline view for subsequent level tests
    
    Selection.HomeKey Unit:=wdStory     'Position at start

'   Write Header line
' PROBLEM - this seems to be added at whatever the current level is
' - hence need to force to style 1.  Note utf-8 does not recognise many extended chars e.g. MegaWikis dot (alt183)
    Insertpnt.InsertBefore "<?xml version=""1.0"" encoding=""ISO-8859-1"" ?>" & vbCrLf _
                        & "<ShadowPlanFile uniqueTime=""0"" uploadFile=""1"">" & vbCrLf
    MyOutput.Paragraphs(1).Style = wdStyleHeading1        'Style 1 so not indented
    MyOutput.Paragraphs(2).Style = wdStyleHeading1        'Style 1 so not indented
    Insertpnt.Collapse Direction:=wdCollapseEnd


'   Check each para and write out recursivly
'   Note that currPara is modified within the recursion
        Set myParas = ActiveDocument.Paragraphs
        For currPara = 1 To myParas.Count
            Writeout currPara:=currPara, Infile:=ActiveDocument, Outfile:=MyOutput, Insertpnt:=Insertpnt
        Next currPara
        Insertpnt.InsertAfter "</item>" & vbCrLf            'Recursion routine stops at "last para -1"

''''If Application.DefaultWebOptions.Encoding =msoEncodingUTF8
'   Write Footer line
    Insertpnt.InsertAfter "</ShadowPlanFile>" & vbCrLf


'   Convert levels to Tabs
        MyOutput.ActiveWindow.View.Type = wdNormalView   'Must not be in outline view for outline level test to succeed
        For currPara = 1 To (MyOutput.Paragraphs.Count - 2)
            Set myRange = MyOutput.Paragraphs(currPara).Range
            Currlevel = MyOutput.Paragraphs(currPara).OutlineLevel    'Style used by that level
            For x = 2 To Currlevel                                    'Works for levels inc level 10, Starts at 2 since no need to indent Lvl 1
                myRange.InsertBefore "   "   'vbTab                            '"..." Dots used during debug for visibility
            Next x
        Next currPara

'   Convert to plain text
        MyOutput.Paragraphs.Style = wdStyleNormal     'Set output file to plain text

'Saves the active document in text-file format, with the file name extension ".xml".
'with the same name and directory as the input file
    myDocname = SourceDoc.Name
    pos = InStr(myDocname, ".")
    If pos > 0 Then
        myDocname = Left(myDocname, pos - 1)
        myDocname = "ShadP-" & myDocname & ".xml"
        ' Check to see if file already exists
        ActiveDocument.SaveEncoding = msoEncodingUTF8
        With Application.FileSearch
            .FileName = myDocname
            .LookIn = SourceDoc.Path
            .Execute
            If .FoundFiles.Count = 1 Then           'File already exists - Ask what to do
                Style = vbYesNoCancel + vbQuestion + vbDefaultButton1    ' Define buttons.
                Title = "File already exists!"    ' Define title.
                ' Define message.
                Msg = "CAUTION" & vbCrLf & "File " & ActiveDocument.Path _
                    & Application.PathSeparator & myDocname & " already exists" & vbCrLf _
                    & "Overwrite file?" & vbCrLf & _
                    "   (NO to select another filename {use .xml}, cancel quits without saving)"
                ' Display message.
                Response = MsgBox(Msg, Style, Title)
                Select Case Response
                    Case vbYes
                       ' User chose Yes - Overwrite file
                        MyOutput.SaveAs FileName:=SourceDoc.Path & Application.PathSeparator _
                        & myDocname, FileFormat:=wdFormatText
'  Tried wdFormatUnicodeText  rather than wdFormatText (didn't work! - caused UTF-8 statement to be unrecognised when browser opens xml)
'  (Unicode is a 16bit format - so word was creating a 16bit format file while the UTF statement was telling browser to open in 8bit.
'  Shadow only recognises 8 bit format.
'  Check for problem with degree symbol now (with wdFormatText).  (Probably just not supported in 8 bit.
                    Case vbNo
                        ' User chose No
                        
                        Windows(MyOutput).Activate
                        With Dialogs(wdDialogFileSaveAs)
                            .Format = wdFormatText    'Seems Format Overrides Name...
                            .Name = "*.*"             'Last part of Name doesnt seem to be recognised
                                                      'This comes out as *.txt
                            .Show
                        End With

                    Case vbCancel
                        ' User chose Cancel/Escape
                        ' Do Nothing - get rid of open doc
                        MyOutput.Close SaveChanges:=wdDoNotSaveChanges
                End Select
            Else                                    'File doesnt yet exist- create it
                MyOutput.SaveAs FileName:=SourceDoc.Path & Application.PathSeparator & myDocname, _
                 FileFormat:=wdFormatText
            End If
        End With
    Else
        Style = vbOKOnly + vbExclamation                        ' Define buttons.
        Title = "DOC File has not previously been saved"    ' Define title.
        Msg = "Invalid input file name - Save active document " & vbCrLf & ActiveDocument.Name _
            & vbCrLf & "and rerun Macro"
        MsgBox Msg, Style, Title
        ' Tidy up- get rid of open output doc
        MyOutput.Close SaveChanges:=wdDoNotSaveChanges
    End If

TempDoc.Close SaveChanges:=wdDoNotSaveChanges
        
End Sub
Sub Writeout(ByVal Infile As Document, ByVal Outfile As Document, ByRef currPara As Long, _
             ByVal Insertpnt As Range)
'
' WriteOut sub
' Uses recursion
'       Write <Item
'       Write   <title
'       Check level of next para
'       If indented
'           Call myself
'       Write </item
'       Check if we have backed out to same level  (check next level against stored level)
'       If we have
'           Call myself
'
'    Dim Currlvl As WdOutlineLevel       'Static didn't work as a recursion store
    Dim Currlvl As Single       'Static didn't work as a recursion store
    Dim ItemHeader As String
    
    Static Prevlvl As WdOutlineLevel
    
'    MsgBox "Para=" & currPara           'DEBUG line
    Infile.Paragraphs(currPara).Range.Copy
'   Write <title
    Insertpnt.Paste
    Currstyle = Infile.Paragraphs(currPara).Style    'Stores Style used by that level so same can be used by corresponding </item

'   Write <Item
    ItemHeader = "<item"
'''TESTING
    If Infile.Paragraphs(currPara).Range.Font.Bold <> False Then _
        ItemHeader = ItemHeader & " dispBold=""yes"""
    If Infile.Paragraphs(currPara).Range.Font.StrikeThrough = True Then _
        ItemHeader = ItemHeader & " checked=""yes"""
    ItemHeader = ItemHeader & ">" & vbCrLf & "<title>"

'''END TESTING
    Insertpnt.InsertBefore ItemHeader   'PROBLEM - perhaps need to move bookmark by 'extend'ing range to END of selection here
    Insertpnt.Collapse Direction:=wdCollapseEnd
    Insertpnt.MoveEnd Unit:=wdCharacter, Count:=-1  'Keep the same level (move back to same para)
    Insertpnt.InsertBefore "</title>" & vbCrLf
    Insertpnt.Collapse Direction:=wdCollapseEnd
'    Insertpnt.MoveEnd Unit:=wdCharacter, Count:=-1  'Keep the same level (move back to same para)
 '   Insertpnt.InsertAfter vbCrLf            'Force a <CR> to prev

    
    If currPara < ActiveDocument.Paragraphs.Count Then       'Test if at end to prevent call trying to read a non-existant i/p para
        Nextlvl = Infile.Paragraphs(currPara + 1).OutlineLevel  'outline level of NEXT para
        Currlvl = Infile.Paragraphs(currPara).OutlineLevel    'returns outline level of para
        If (Currlvl <> 10) Then
            Prevlvl = Currlvl
        ElseIf (Nextlvl > Prevlvl) And (Nextlvl <> 10) Then     'Currlvl=10 AND nextlvl > Prevlvl: Tests for Level 10 between levels
'            MsgBox "Level 10 between levels"
            Currlvl = Prevlvl + 0.5
        End If

        If Nextlvl > Currlvl Then
'            MsgBox "Indent"                 'DEBUG line
            currPara = currPara + 1
            Writeout Infile, Outfile, currPara, Insertpnt
        End If
        
'        Insertpnt.MoveEnd Unit:=wdCharacter, Count:=-1  'Keep the same level (move back to same para)
                                                        ' If this isn't in, all the <'s are at level 10!
                                                        ' If this is in, the < (next line) needs a leading CR added
        Insertpnt.InsertAfter "</item>" & vbCrLf
   'Try this... When coming back out force the correct format before collapsing...
'   Outfile.Activate  '- debug line
'   ActiveDocument.Range.Select  'tries to make current selection point visible for debug
'    Insertpnt.Paragraphs.OutlineLevel = Currlvl    'force the correct format wont work...
    'PROBLEM...
    ' "If a paragraph has a heading style applied to it (Heading 1 through Heading 9),
    ' the outline level is the same as the heading style and cannot be changed."
    ' I Would prefer not to mess with styles if I can possibly avoid it!.
'Whats needed is
'    If Currlvl has a style
'       Then
'           Apply that style   e.g.    Selection.Style = ActiveDocument.Styles("Heading 5")
'       Else
'           Force correct format
   Insertpnt.Style = Currstyle  'This works
'  Insertpnt.Style = Outfile.Styles(Currlvl)   'DOESNT WORK - Keeps dropping everything to levl 10!!!!


'  ActiveDocument.Range.Select  'tries to make current selection point visible for debug

        Insertpnt.Collapse Direction:=wdCollapseEnd     'New Para
        
        If currPara < ActiveDocument.Paragraphs.Count Then       'Test if at end to prevent call trying to read a non-existant i/p para
            'Recheck "nextlvl" on way out of recursion
            Nextlvl = Infile.Paragraphs(currPara + 1).OutlineLevel  'outline level of NEXT para
            If Nextlvl >= Currlvl Then           ' Currlvl here is the one stored (static) when recursed at this level
'                MsgBox "Backed out to same level"          'DEBUG line
                currPara = currPara + 1
                Writeout Infile, Outfile, currPara, Insertpnt
            End If
        End If
    End If
    
 '  Write </item
 '   Insertpnt.Collapse Direction:=wdCollapseEnd        'MAY NEED THIS LINE
 '   Insertpnt.InsertParagraph   'Seems to insert a text (Level 10) para
    
'    Insertpnt.MoveEnd Unit:=wdCharacter, Count:=-1  'Keep the same level (move back to same para)
'   ActiveDocument.Range.Select  'tries to make current selection point visible for debug

'    Insertpnt.InsertAfter vbCrLf            'Force a <CR> to prev
'    Insertpnt.InsertAfter vbCrLf & "<"   ' & vbCrLf  (removed extra <CR>
'    Insertpnt.Collapse Direction:=wdCollapseEnd     'New Para

'    Insertpnt.InsertAfter "</item>" & vbCrLf
'    Insertpnt.Collapse Direction:=wdCollapseEnd
'
End Sub

Sub ReplaceXMLreserved(FileName As Document)
'
' ReplaceXMLreserved Macro
' Checks input file for XML reserved characters and replaces them:
'   <  -> &lt;
'   >  -> &gt;
'   &  -> &amp;
'   "  -> &quot;
'   '  -> &apos;
'
    With FileName.Content.Find
         Selection.HomeKey Unit:=wdStory     'Position at start
        .Text = "&"
        .Replacement.Text = "&amp;"
        .Execute Replace:=wdReplaceAll, Forward:=True, Wrap:=wdFindStop
        
        .Text = "<"
        .Replacement.Text = "&lt;"
        .Execute Replace:=wdReplaceAll, Forward:=True, Wrap:=wdFindStop
    
        .Text = ">"
        .Replacement.Text = "&gt;"
        .Execute Replace:=wdReplaceAll, Forward:=True, Wrap:=wdFindStop
    
        .Text = """"
        .Replacement.Text = "&quot;"
        .Execute Replace:=wdReplaceAll, Forward:=True, Wrap:=wdFindStop
    
        .Text = "'"
        .Replacement.Text = "&apos;"
        .Execute Replace:=wdReplaceAll, Forward:=True, Wrap:=wdFindStop
    End With
'   ActiveDocument.StoryRanges
End Sub
