#include <PalmOS.h>
#include <Standalone.h>
#include "SL5Hack.h"

#define mycreator 'SPLk'

typedef struct {
	Int16 trigger;
} ShadLinkPrefType;

STANDALONE_CODE_RESOURCE_ID (2000);

static Boolean ShadLinkConfHandler(EventPtr event)
{
	Boolean handled=false;
	FormType *form;
	ShadLinkPrefType pref;
	UInt16 prefSize;

	// check preference
	prefSize = sizeof(ShadLinkPrefType);
	if (PrefGetAppPreferences(mycreator, 1, &pref, &prefSize, true) == noPreferenceFound)
	{
		pref.trigger = pushID_DoubleTap;
		PrefSetAppPreferences(mycreator,1,1,&pref,sizeof(pref),true);
	}

	switch (event->eType)
	{
		case frmOpenEvent:
			form=FrmGetActiveForm();
			FrmSetControlGroupSelection(form,1,pref.trigger);
			FrmDrawForm(form);
			handled=true;
			break;

		case ctlSelectEvent:
				switch (event->data.ctlSelect.controlID)
				{
					case buttonID_Done:
						form=FrmGetActiveForm();
						pref.trigger= FrmGetObjectId(form,FrmGetControlGroupSelection(form,1));
						PrefSetAppPreferences(mycreator,1,1,&pref,sizeof(pref),true);
						FrmGotoForm(9000);
					   	handled=true;
						break;

					default: break;
				}

		default: break;
	}
	return handled;
}
