/*********************************************************************

SL5App.c

Ver 5.1
- Suspend notifications before HotSync and resume afterwards

Ver 5.0 - ONLY for PalmOS 5
- (1.2.4) Use deferred notification for single-tap
- (1.2.3) Change to use notification
- (1.2.2) Change trap to SysHandleEvent to work w/ extension manager under OS5

Copyright (C) 2002 Ling Nero
 
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

RnLNero@yahoo.com

 ********************************************************************/

#include <PalmOS.h>
#include <SysEvtMgr.h>
#include <Standalone.h>
#include "SL5App.h"

#define myDeferredNotifyEvent SPLK_CRID

#define ByteSwap16(n)	( ((((unsigned int) n) << 8) & 0xFF00) | \
						  ((((unsigned int) n) >> 8) & 0x00FF) )

static void StartApp(void);
static void EventLoop(void);
static void StopApp(void);
static void UnregisterForNotifications(void);
static void RegisterForNotifications(void);
static void SetupNotifications(void);
static Boolean ShadLinkConfHandler(EventPtr);
static Boolean WrongOSHandler(EventPtr);
static Boolean AppHandleEvent(EventPtr);
static void Beep(UInt16, UInt16);
static Boolean DoAction(FieldPtr);
Err ShadowLink(SysNotifyParamType *);

typedef struct {
	Int16 trigger;
	Boolean enable;
} ShadLinkPrefType;

UInt32 PilotMain(UInt16 cmd, void *cmdPBP, UInt16 launchFlags)
{
	SysNotifyParamType *notify;
    UInt16 cardNo;
    LocalID dbID;

	switch (cmd)
	{
        case sysAppLaunchCmdNormalLaunch: 
			StartApp();
			EventLoop();
			StopApp();
			break;
			
		case sysAppLaunchCmdNotify:
			notify = (SysNotifyParamType *)cmdPBP;
			notify->handled=false;

			switch (notify->notifyType)
			{
				case sysNotifySyncStartEvent:
				//	Beep(4,sndStartUp);
					UnregisterForNotifications();
    				if (SysCurAppDatabase(&cardNo, &dbID) == 0)
						SysNotifyRegister(cardNo, dbID, sysNotifySyncFinishEvent, NULL, sysNotifyNormalPriority, 0);
					break; 

				case sysNotifySyncFinishEvent:
			//		Beep(4,sndError);
					RegisterForNotifications();
    				if (SysCurAppDatabase(&cardNo, &dbID) == 0)
						SysNotifyUnregister(cardNo, dbID, sysNotifySyncFinishEvent, sysNotifyNormalPriority);
					break;

				default: ShadowLink((SysNotifyParamType *)cmdPBP);
						 break;
			}
			break;

		case sysAppLaunchCmdSystemReset:
   		case sysAppLaunchCmdSyncNotify:
      			SetupNotifications();
      		break;
	}

	return 0;

}

static void StartApp(void)
{
	UInt32 romVersion;

	FtrGet(sysFtrCreator, sysFtrNumROMVersion, &romVersion);
	if (sysGetROMVerMajor(romVersion) < 5)
		FrmGotoForm(2001);
	else FrmGotoForm(2000);
}

static void EventLoop(void)
{
	UInt16 error;
	EventType event;

	do
	{
		EvtGetEvent(&event, evtWaitForever);
		
		if (SysHandleEvent(&event)) continue;
		if (MenuHandleEvent(0,&event,&error)) continue;
		if (AppHandleEvent(&event)) continue;
		FrmDispatchEvent(&event);
	}
	while (event.eType != appStopEvent);
	return;
}

static Boolean AppHandleEvent(EventPtr eventP)
{
	UInt16 formID;
	FormType *frmP;

	if (eventP->eType == frmLoadEvent)
	{
		formID = eventP->data.frmLoad.formID;
		frmP = FrmInitForm(formID);
		FrmSetActiveForm(frmP);

		switch (formID)
		{
			case 2000:
				FrmSetEventHandler(frmP,(FormEventHandlerType *)ShadLinkConfHandler);
				break;

			case 2001:
				FrmSetEventHandler(frmP, (FormEventHandlerType *)WrongOSHandler);
				break;
			default: ErrFatalDisplay("Invalid Form Load Event");
					 break;
		}
		
		return true;
	}
	return false;
}

static Boolean WrongOSHandler(EventPtr eventP)
{
	Boolean handled=false;
	FormType *frmP;

	switch (eventP->eType)
	{
		case frmOpenEvent:
			frmP=FrmGetActiveForm();
			FrmDrawForm(frmP);
			handled=true;
			break;

		case menuEvent:
			switch (eventP->data.menu.itemID)
			{
				case menuitemID_About:
					frmP=FrmInitForm(3000);
					FrmDoDialog(frmP);
					FrmDeleteForm(frmP);
					break;

				default: break;
			}
			break;

		default:
			break;
	}

	return handled;
}

static Boolean ShadLinkConfHandler(EventPtr eventP)
{
	Boolean handled=false;
	FormType *frmP;
	ShadLinkPrefType pref;
	UInt16 prefSize;

	// check preference
	prefSize = sizeof(ShadLinkPrefType);
	if (PrefGetAppPreferences(SPLK_CRID, 2, &pref, &prefSize, true) == noPreferenceFound)
	{
		pref.trigger = pushID_DoubleTap;
		pref.enable = false;
		PrefSetAppPreferences(SPLK_CRID,2,1,&pref,sizeof(pref),true);
	}

	switch (eventP->eType)
	{
		case frmOpenEvent:
			frmP=FrmGetActiveForm();
			FrmSetControlGroupSelection(frmP,1,pref.trigger);
			FrmSetControlValue(frmP, FrmGetObjectIndex(frmP,checkboxID_Enable), pref.enable);
			FrmDrawForm(frmP);
			handled=true;
			break;

		case menuEvent:
			switch (eventP->data.menu.itemID)
			{
				case menuitemID_About:
					frmP=FrmInitForm(3000);
					FrmDoDialog(frmP);
					FrmDeleteForm(frmP);
					break;

				default: break;
			}
			break;

		default: break;
	}
	return handled;
}

static void RegisterForNotifications(void)
{
    UInt16 cardNo;
    LocalID dbID;
 
    if (SysCurAppDatabase(&cardNo, &dbID) != 0)
       return; // shouldn't ever fail, but just in case.
 
    SysNotifyRegister(cardNo, dbID, sysNotifyEventDequeuedEvent, NULL, sysNotifyNormalPriority, 0);
    SysNotifyRegister(cardNo, dbID, myDeferredNotifyEvent, NULL, sysNotifyNormalPriority, 0);
	SysNotifyRegister(cardNo, dbID, sysNotifySyncStartEvent, NULL, sysNotifyNormalPriority, 0);
}

static void UnregisterForNotifications(void)
{
    UInt16 cardNo;
    LocalID dbID;
 
    if (SysCurAppDatabase(&cardNo, &dbID) != 0)
       return; // shouldn't ever fail, but just in case.
 
    SysNotifyUnregister(cardNo, dbID, sysNotifyEventDequeuedEvent, sysNotifyNormalPriority);
    SysNotifyUnregister(cardNo, dbID, myDeferredNotifyEvent, sysNotifyNormalPriority);
	SysNotifyUnregister(cardNo, dbID, sysNotifySyncStartEvent, sysNotifyNormalPriority);
}

static void SetupNotifications(void)
{
	UInt16 prefSize;
	ShadLinkPrefType pref;

	prefSize = sizeof(ShadLinkPrefType);
	if (PrefGetAppPreferences(SPLK_CRID, 2, &pref, &prefSize, true) == noPreferenceFound)
	{
		pref.trigger = pushID_DoubleTap;
		pref.enable = false;
		PrefSetAppPreferences(SPLK_CRID,2,1,&pref,sizeof(pref),true);
	}
	if (pref.enable)
   		RegisterForNotifications();
	else UnregisterForNotifications();
}

static void StopApp(void)
{
	FormType *frmP;
	ShadLinkPrefType pref;

	if (FrmGetActiveFormID() == 2000)
	{
		frmP=FrmGetActiveForm();
		pref.trigger= FrmGetObjectId(frmP,FrmGetControlGroupSelection(frmP,1));
		pref.enable= FrmGetControlValue(frmP, FrmGetObjectIndex(frmP,checkboxID_Enable));
		PrefSetAppPreferences(SPLK_CRID,2,1,&pref,sizeof(pref),true);
		if (pref.enable)
   			RegisterForNotifications();
		else UnregisterForNotifications();
	}
		
	FrmCloseAllForms();
}

Err ShadowLink(SysNotifyParamType *notifyParamsP)
{
	UInt16 f;
	FieldPtr fldP;
	ShadLinkPrefType pref;
	UInt16 prefSize;
	Boolean handled;
	FormPtr oldform;
	EventPtr eventP;
	SysNotifyParamType notifyParam;
	
	handled=false;

	eventP = (EventPtr) (notifyParamsP->notifyDetailsP);

	if (notifyParamsP->notifyType != myDeferredNotifyEvent && eventP->eType != ByteSwap16(penDownEvent) && eventP->eType != ByteSwap16(fldEnterEvent))
		goto end;

	oldform=FrmGetActiveForm();

	if (oldform == NULL)
		goto end;

	f = FrmGetFocus(oldform);
	if (f != noFocus) // form has a focus
	{
		if (FrmGetObjectType(oldform,f) == frmFieldObj) // and it's a field
		{ 	
			fldP = FrmGetObjectPtr(oldform,f);
			if (fldP == NULL)
				goto end;

			if (notifyParamsP->notifyType == myDeferredNotifyEvent)
			{
				handled = DoAction(fldP);
				goto end;
			}
	/* what's the trigger? */

			prefSize = sizeof(ShadLinkPrefType);
			if (PrefGetAppPreferences(SPLK_CRID, 2, &pref, &prefSize, true) == noPreferenceFound)
			{
				pref.trigger = pushID_DoubleTap;
				pref.enable= true;
				PrefSetAppPreferences(SPLK_CRID,2,1,&pref,sizeof(pref),true);
			}

			switch (pref.trigger)
			{
				case pushID_DoubleTap :
						if (eventP->eType == ByteSwap16(penDownEvent) && eventP->tapCount == 2)
						{
						//	Beep(1,sndStartUp);
							handled = DoAction(fldP);
						}
					break;

				case pushID_SingleTap :
						if (eventP->eType == ByteSwap16(fldEnterEvent))
						{
							notifyParam.notifyType = myDeferredNotifyEvent;
							notifyParam.broadcaster = SPLK_CRID;
							notifyParam.notifyDetailsP = NULL;
							notifyParam.handled = false;
							SysNotifyBroadcastDeferred(&notifyParam,NULL);
						}
					break;

				default: break;
			} // switch

		} // if frmObjectKind
	} // if form has focus

end:
	notifyParamsP->handled = handled;
	return 0;
}

static Boolean DoAction(FieldPtr fP)
{
	LocalID dbID;
	UInt32 uniqueID, outStart, outEnd;
	UInt16 cardNo, cursor, tagLen, fLen, i, j, k, cliplength, startPos, endPos, attrP;
	MemHandle fTextH, resH;
	MemPtr fTextP, clipP, resP, listName;
	Char ShadowTag[20], *strP, *listNameP;
	DmOpenRef refDB;
	GoToParamsType *cmdPBP;
	DmSearchStateType stateInfoP;

	fTextH = NULL;
	cmdPBP = NULL;

	if (fP == NULL)
		goto cleanup;

	refDB=DmOpenDatabaseByTypeCreator('appl',SPLK_CRID,dmModeReadOnly);
	if (!refDB)
		goto cleanup;

	resH = DmGet1Resource(strRsc, 2000);
	resP = MemHandleLock(resH);
	StrCopy(ShadowTag,resP);
	MemHandleUnlock(resH);
	DmReleaseResource(resH);
	DmCloseDatabase(refDB);

	/* get a chunk of the text around cursor */
	tagLen = StrLen(ShadowTag);
	fLen = FldGetTextLength(fP);
	if (fLen <= tagLen)
		goto cleanup;

	cmdPBP = (GoToParamsType *) MemPtrNew(sizeof(GoToParamsType));
	if (!cmdPBP)
		goto cleanup;

	cursor = FldGetInsPtPosition(fP);
	if (cursor <= tagLen)
		startPos = 0;
	else startPos = cursor - tagLen;
	endPos = cursor + tagLen;
	if (endPos > fLen-1)
		endPos = fLen-1;

	clipP = FldGetTextPtr(fP);
	strP = (char *)clipP;
	TxtCharBounds(strP, startPos, &outStart, &outEnd);
	startPos = outStart;
	TxtCharBounds(strP, endPos, &outStart, &outEnd);
	endPos = outEnd;

	cliplength = endPos - startPos + 1;
	fTextH = MemHandleNew(cliplength+1);
	if (!fTextH)
		goto cleanup;

	fTextP = MemHandleLock(fTextH);

	strP += startPos;
	MemMove(fTextP, (void *)strP, cliplength);

	strP = (char *)fTextP;
	strP[cliplength] = NULL;

	if (cliplength >= tagLen)
	for (i=0; i<=cliplength-tagLen && cursor >= startPos+i; i += TxtNextCharSize(strP,i))
	{
		if (TxtCompare(&strP[i], tagLen, NULL, ShadowTag, tagLen, NULL) == 0)
		{
//				Beep(1,sndWarning);

				/* Extract information to set up cmdPBP */

				startPos += i; 					// set to first '['
				startPos += tagLen;				// skip tag and point to '('
				endPos = fLen;

				/* get the rest of the tag */
				cliplength = endPos - startPos + 1;
				clipP = FldGetTextPtr(fP);
				MemHandleUnlock(fTextH);
				if (MemHandleResize(fTextH, cliplength+1))
					goto cleanup;

				fTextP = MemHandleLock(fTextH);
				strP = (char *)clipP;
				strP += startPos;
				MemMove(fTextP, (void *)strP, cliplength);
				strP = (char *)fTextP;
				strP[cliplength] = NULL;

				uniqueID = 0;

				/* Extract uniqueID */
				if (strP[0] == '(')
				{
					for (i=1; strP[i] != ')' && strP[i] != NULL; i++)
						if (strP[i] < '0' || strP[i] > '9') // bad uniqueID
							goto cleanup;

					if (strP[i] == NULL)			// bad form
						goto cleanup;
						
					for (j=1; j<i; j++)
						uniqueID = uniqueID * 10 + (strP[j] - '0');

					/* strP[i] shound be ')', so skip ahead 2 */
					i += 2;
				}
				else i=0;
					
				/* Extract list name */
				/* skip to end of list name */
				j=i;

extract:
				for (; strP[j] != '>' && strP[j] != ']' && strP[j] != NULL; j += TxtNextCharSize(strP,j));

				if (strP[j] == NULL)			// uh-oh, bad form
					goto cleanup;

				if (strP[j] == ']')				// make sure ']' is not part of the file name
				{
					for (k=0; strP[j+k] == ']' && strP[j+k] != NULL; k += TxtNextCharSize(strP,j+k));

					if (k < 3) // don't have ']]]'
					{
						j= j+k;
						goto extract;
					}
					if (k > 3)
						j = j+k-3;
				}

				if (strP[j] == '>')				// need to get rid of trailing space
					j--;

				j--;
				listName = MemPtrNew(j-i+8);
				if (!listName)
					goto cleanup;
				listNameP = (char *)listName;
				StrCopy(listNameP, "ShadP-");
				StrNCopy(&listNameP[6], &strP[i], j-i+1);
				listNameP[6+j-i+1] = NULL;

				/* Find list */
				cmdPBP->dbCardNo=0;
				cmdPBP->dbID = DmFindDatabase(0,listNameP);
				MemPtrFree(listName);

				if (cmdPBP->dbID == 0) // it doesn't exist
					goto cleanup;

				/* Find Shadow */
				if (DmGetNextDatabaseByTypeCreator(true, &stateInfoP,'appl','Coog',true,&cardNo,&dbID) != errNone)
					goto cleanup;

				if (uniqueID != 0)
				{
					/* open list */
					refDB = DmOpenDatabase(cmdPBP->dbCardNo,cmdPBP->dbID,dmModeReadOnly);
					if (!refDB)
						goto cleanup;

					/* find record by uniqueID */
					if (DmFindRecordByID(refDB, uniqueID, &(cmdPBP->recordNum)) != 0)
					{
						cmdPBP->recordNum = 1;
						attrP=0;
					}
					/* check if record is not deleted */
					else DmRecordInfo(refDB, cmdPBP->recordNum, &attrP, NULL, NULL);
					DmCloseDatabase(refDB);

					if (attrP & dmRecAttrDelete)
						goto cleanup;
				}
				else cmdPBP->recordNum = 1;

				cmdPBP->matchFieldNum=cmdPBP->recordNum-1;
				cmdPBP->matchPos = 0;
				cmdPBP->matchCustom = 0;
				cmdPBP->searchStrLen=0;

				MemHandleUnlock(fTextH);
				MemHandleFree(fTextH);

				MemPtrSetOwner(cmdPBP, 0);
						
				SysUIAppSwitch(cardNo, dbID, sysAppLaunchCmdGoTo,cmdPBP);
				return 1;
		}
	}

cleanup:

	if (fTextH)
	{
		MemHandleUnlock(fTextH);
		MemHandleFree(fTextH);
	}
	if (cmdPBP)
		MemPtrFree(cmdPBP);

	return 0;
}

void Beep(UInt16 times,UInt16 type)
{
	UInt16 i;

	for (i=0; i<times; i++)
		SndPlaySystemSound(type);
}
