#include <u.h>
#include <libc.h>
#include <avl.h>
#include <bio.h>
#include "indental.h"

int
srvstart(char * s){
	int fd, p[2];
	
	pipe(p);
	fd = create(s, ORCLOSE|OWRITE, 0660);
	fprint(fd, "%d", p[1]);
	return p[0];
}

void
main ( int , char ** ){
	int fdc = srvstart("#s/slov.cmd");
	Biobuf *cmdstream = Bfdopen(fdc, OREAD);

	int fdd = srvstart("#s/slov.dat");
	Biobuf *datstream = Bfdopen(fdd, OWRITE);

	char * line;
	tree = avlcreate(ndtlcmp);	
	
	while(line = Brdstr(cmdstream, '\n', 1)){
		switch( line[0] ){
			case 'i' :
			case 'I' :
				ndtlparse(cmdstream);
			//	walk(tree, datstream, printndtlnode, 0);
				break;
			case 'd' :
			case 'D' :
				ndtldelete(cmdstream);
			//	walk(tree, datstream, printndtlnode, 0);
				break;
			case 'l' :
			case 'L' :
				ndtllookup(cmdstream, datstream);
				break;
			case 'f' :
			case 'F' :
				ndtlfind(cmdstream, datstream);
				break;
			default :
				break;
		}

		free(line);
		Bflush(datstream);
	}
	
	
	
}

