#include <u.h>
#include <libc.h>
#include <avl.h>
#include <bio.h>
#include <regexp.h>
#include "indental.h"

Avltree * tree;
/*
char * s_nmrx = "^ *	*{([!-z][^{}[]*)[{}]";
char * s_kvrx = ",?{? ?([^{} ,:]+ *[^{},:]+) ?: ?([^{} ,:]+ *[^{},:]+),?{?}?";
char * s_lnrx = "{?,? ?([!-z][^[]*)\[";
char * s_lirx = ",?\[?([^,[\]]+)]?,?";
*/


char * cmrx = "^[ 	]*;";
char * eofrx = "^[ 	]*!$";
char * whrx = "^[ 	]*$";
char * nmrx = "^([^	 :][^:]+)[ 	]*$";
char * kvrx = "^[ 	]([^ :	][^:]+) +: +(.+)[ 	]*$";
char * kvarx = "^[ 	]*([^ :	][^:]+) +: +(.+)[ 	]*$";
char * lnrx = "^[ 	]([^ 	].*)[ 	]*$";
char * lirx = "^[ 	][ 	](.+)";


char * ld_nmrx = "^([^	 :][^:]+)";
char * ld_klrx = "^[ 	]([^ 	].*)";
char * ld_lirx = "^[ 	][ 	](.+)";




/*****************************************
char * cmdlookuprx = "^[ 	]*lookup";
char * cmddeleterx = "^[ 	]*delete";
char * cmdinsertrx = "^[ 	]*insert";

char * datafile = "ndtl.data";
char * cmdfile = "ndtl.cmd";
char * datasrv = "/srv/ndtl.data";
char * cmdsrv = "/srv/ndtl.cmd";
*****************************************/

int
mcuistrcmp(char* a, char* b){
	int ret;
	char * at = malloc(strlen(a) + 1);
	char * bt = malloc(strlen(b) + 1);
	for(int i = strlen(a) ; i >= 0; i--){
		at[i] = ( (a[i] == '_') ? ' ': ( (a[i] > 'Z' && a[i] < '{' ) ? (a[i]-' '):a[i]) );
	}
	for(int i = strlen(b) ; i >= 0; i--){
		bt[i] = ( (b[i] == '_') ? ' ': ( (b[i] > 'Z' && b[i] < '{' ) ? (b[i]-' '):b[i]) );
	}
	ret = strcmp(at,bt);
	free(at);
	free(bt);
	return ret;
}


int ndtlcmp( Avl * i , Avl * j){
	ndtlnode *I = (ndtlnode*) i;
	ndtlnode *J = (ndtlnode*) j;
	return mcuistrcmp(I->name, J->name);
}
int kvcmp( Avl * i , Avl * j){
	kvnode *I = (kvnode*) i;
	kvnode *J = (kvnode*) j;
	return mcuistrcmp(I->key, J->key);
}
int lcmp( Avl * i , Avl * j){
	lnode *I = (lnode*) i;
	lnode *J = (lnode*) j;
	return mcuistrcmp(I->name, J->name);
}
int licmp( Avl * i , Avl * j){
	linode *I = (linode*) i;
	linode *J = (linode*) j;
	return I->index - J->index ;
}

void
freendtlnode(Avl * n){
	ndtlnode * N = (ndtlnode*) n;
	kvnode * KVN;
	lnode * LN;
	kvnode KVkey;
	lnode Lkey;
	KVkey.key ="";
	Lkey.name ="";

	free(N->name);
	if(N->kvtree){
		while(KVN = (kvnode*) avllookup(N->kvtree, &KVkey, -1)){
			KVN =(kvnode*) avldelete(N->kvtree, KVN);
			freekvnode(KVN);
		}
		free(N->kvtree);
	}

	if(N->ltree){
		while(LN = (lnode*) avllookup(N->ltree, &Lkey, -1) ){
			LN = (lnode*) avldelete(N->ltree, LN);
			freelnode(LN);
		}
		free(N->ltree);
	}
	free(N);
}
void
freekvnode(Avl * kv){
	kvnode * KV = (kvnode *)kv;
	free(KV->key);
	free(KV->val);
	free(KV);
}
void
freelnode(Avl * l){
	lnode * L = (lnode*) l;
	linode * LIN;
	linode LIkey;
	LIkey.index = 0;
	free(L->name);
	if(L->litree){
		while(LIN = (linode*) avllookup(L->litree, &LIkey, 1)){
			LIN =(linode*) avldelete(L->litree, LIN);
			freelinode(LIN);
		}
		free(L->litree);
	}
	free(L);
}
void
freelinode(Avl * li){
	linode * LI = (linode *) li;
	free(LI->value);
	free(LI);
}
void printndtlnames(Avl * n, Biobuf *s, int){
	ndtlnode * N = (ndtlnode*)n;
	Bprint(s, "%s\n",N->name);
	Bprint(s, "\n");
}
void printndtlnode(Avl * n, Biobuf *s, int){
	ndtlnode * N = (ndtlnode*)n;
	Bprint(s, "%s\n",N->name);
	walk(N->kvtree, s, printkvnode, 1);
	walk(N->ltree, s, printlnode, 0);
	Bprint(s, "\n");
}
void printkvnode(Avl * n, Biobuf *s, int){
	kvnode * N = (kvnode *)n;
	Bprint(s, "	%s : %s\n", N->key, N->val);
}
void printkey(Avl * n, Biobuf *s, int){
	kvnode * N = (kvnode *)n;
	Bprint(s, "	%s\n", N->key);
}
void printkval(Avl * n, Biobuf *s, int){
	kvnode * N = (kvnode *)n;
	Bprint(s, "	%s\n", N->val);
}
void printlname(Avl * n, Biobuf *s, int ){
	lnode * N = (lnode *)n;
	Bprint(s, "	%s\n", N->name);
}
void printlnode(Avl * n, Biobuf *s, int dir){
	lnode * N = (lnode *)n;
	Bprint(s, "	%s\n", N->name);
	walk(N->litree, s, printlinode, dir);
}
void printlinode(Avl * n, Biobuf *s, int){
	linode * N = (linode *)n;
	Bprint(s, "		%s\n", N->value);
}

#define MSZ 3
Resub match[MSZ];

char * 
copymatch(int i)
{
	int len;
	char * s_match;
	if(match[i].ep && match[i].sp && match[i].ep > match[i].sp){
		len = (long long)match[i].ep - (long long)match[i].sp;
		s_match = malloc(len+1);
		strncpy(s_match,match[i].sp, len);
		s_match[len] = 0;
		for(int i = len -1 ; s_match[i] == ' ' || s_match[i] == '	'; i--)
			s_match[i] = 0;
		return s_match;
	}
	return nil;
}

void
walk(Avltree* tree, Biobuf *s, void(*action)(Avl*, Biobuf *s,int dir), int dir)
{
	Avl * dot;
	if(dir){dot = avlmax(tree);} else {dot = avlmin(tree);}
	do{
		if(dot)
			action(dot, s, dir);
	}while (dot = dir?avlprev(dot):avlnext(dot));
}
void
ndtldelete(Biobuf * bioi) {
	Reprog * cmrp = regcomp(cmrx);
	Reprog * whrp = regcomp(whrx);
	Reprog * nmrp = regcomp(ld_nmrx);
	Reprog * klrp = regcomp(ld_klrx);
	Reprog * lirp = regcomp(ld_lirx);
	Reprog * eofrp = regcomp(eofrx);

	Avl  * dup;
	char * line;
	ndtlnode * recentnn = nil;
	kvnode   * recentkvn = nil;
	lnode    * recentln = nil;
	linode   * recentlin = nil;
	int invalid = 0;
	
	
	while(line = Brdstr(bioi, '\n', 1)){

		match[0].sp = match[0].ep = 0;
		if(regexec(cmrp, line, match, MSZ)){
			free(line);
			continue;
		}
		match[0].sp = match[0].ep = 0;
		if(regexec(whrp, line, match, MSZ)){
			free(line);
			continue;
		}

		match[0].sp = match[0].ep = 0;
		if(regexec(nmrp, line, match, MSZ)){
			recentnn = (ndtlnode*)malloc(sizeof(ndtlnode));
			recentnn->name = copymatch(1);
			recentnn->kvtree = nil;
			recentnn->ltree = nil;
			if(dup = avllookup(tree, recentnn, 0)){
				freendtlnode(recentnn);
				recentnn = (ndtlnode*)dup;
			} else {
				freendtlnode(recentnn);
				recentnn = nil;
				invalid = 1;
			}
			free(line);
			continue;
		}

		match[0].sp = match[0].ep = 0;
		if(regexec(klrp, line, match, MSZ)){
			recentln = (lnode*)malloc(sizeof(lnode));
			recentln->name = copymatch(1);
			recentln->litree = nil;
			if(dup = avllookup(recentnn->ltree, recentln, 0)){
				freelnode(recentln);
				recentln = (lnode*) dup;
			} else {
				freelnode(recentln);
				recentln = nil;
				recentkvn = (kvnode*)malloc(sizeof(kvnode));
				recentkvn->key = copymatch(1);
				if(dup = avllookup(recentnn->kvtree, recentkvn, 0)){
					freekvnode(recentkvn);
					recentkvn = (kvnode*)dup;
				} else {
					freekvnode(recentkvn);
					recentkvn = nil;
					invalid = 1;
				}
			}
				
			free(line);
			continue;
		}
		match[0].sp = match[0].ep = 0;
		if(regexec(lirp, line, match, MSZ)){
			recentlin = (linode*)malloc(sizeof(linode));
			recentlin->value = copymatch(1);
			recentlin->index = atoi(recentlin->value);
			free(recentlin->value);
			recentlin->value = nil;
			if(recentln){
				if(dup = avllookup(recentln->litree, recentlin, 0)){
					freelinode(recentlin);
					recentlin = (linode*) dup;
				} else {
					freelinode(recentlin);
					recentlin = nil;
					invalid = 1;
				}
			}
			free(line);
			continue;
		}
		match[0].sp = match[0].ep = 0;
		if(regexec(eofrp, line, match, MSZ)){
		//	print("got to end\n");
			free(line);
			break;
		}
		free(line);

	}
	
	if(recentnn && !invalid){
		if(recentln){
			if(recentlin){
				recentlin = (linode*)avldelete(recentln->litree, recentlin);
				freelinode(recentlin);
					//should update all the list items after to have new index
			} else {
				recentln = (lnode*)avldelete(recentnn->ltree, recentln);
				freelnode(recentln);
			}
		} else if(recentkvn){
			recentkvn = (kvnode*)avldelete(recentnn->kvtree, recentkvn);
			freekvnode(recentkvn);
		} else {
			recentnn = (ndtlnode*)avldelete(tree, recentnn);
			freendtlnode(recentnn);
		}
	} else {
		fprint(2, "delete item not found\n");
	}

	free(cmrp);
	free(whrp);
	free(nmrp);
	free(klrp);
	free(lirp);
	free(eofrp);
}

void
ndtllookup(Biobuf * bioi, Biobuf * bioo) {
	Reprog * cmrp = regcomp(cmrx);
	Reprog * whrp = regcomp(whrx);
	Reprog * nmrp = regcomp(ld_nmrx);
	Reprog * klrp = regcomp(ld_klrx);
	Reprog * lirp = regcomp(ld_lirx);
	Reprog * eofrp = regcomp(eofrx);

	Avl  * dup;
	char * line;
	int triedtofindlist = 0;
	int wantlists = 0;
	int wantkeys = 0;
	int gotanything = 0;
	char * tstr;
	ndtlnode * recentnn = nil;
	kvnode   * recentkvn = nil;
	lnode    * recentln = nil;
	linode   * recentlin = nil;
	
	
	while(line = Brdstr(bioi, '\n', 1)){

		match[0].sp = match[0].ep = 0;
		if(regexec(cmrp, line, match, MSZ)){
			free(line);
			continue;
		}
		match[0].sp = match[0].ep = 0;
		if(regexec(whrp, line, match, MSZ)){
			free(line);
			continue;
		}
		match[0].sp = match[0].ep = 0;
		if(regexec(eofrp, line, match, MSZ)){
		//	print("got to end\n");
			free(line);
			break;
		}
		match[0].sp = match[0].ep = 0;
		if(regexec(nmrp, line, match, MSZ)){
			gotanything = 1;
			recentnn = (ndtlnode*)malloc(sizeof(ndtlnode));
			recentnn->name = copymatch(1);
			recentnn->kvtree = nil;
			recentnn->ltree = nil;
			if(dup = avllookup(tree, recentnn, 0)){
				freendtlnode(recentnn);
				recentnn = (ndtlnode*)dup;
			} else {
				freendtlnode(recentnn);
				recentnn = nil;
			}
			free(line);
			continue;
		}

		match[0].sp = match[0].ep = 0;
		if(regexec(klrp, line, match, MSZ)){
			gotanything = 1;
			if(recentnn == nil){
				free(line);
				continue;
			}
			triedtofindlist = 1;
			recentln = (lnode*)malloc(sizeof(lnode));
			recentln->name = copymatch(1);
			recentln->litree = nil;
			if(dup = avllookup(recentnn->ltree, recentln, 0)){
				freelnode(recentln);
				recentln = (lnode*) dup;
			} else {
				freelnode(recentln);
				recentln = nil;
				recentkvn = (kvnode*)malloc(sizeof(kvnode));
				recentkvn->key = copymatch(1);
				if(dup = avllookup(recentnn->kvtree, recentkvn, 0)){
					
					freekvnode(recentkvn);
					recentkvn = (kvnode*)dup;
				} else {
					tstr = copymatch(1);
					if(mcuistrcmp(tstr, "list") == 0){
						wantlists = 1;
					}
					if(mcuistrcmp(tstr, "key") == 0){
						wantkeys = 1;
					}
					free(tstr);
					freekvnode(recentkvn);
					recentkvn = nil;
				}
			}
				
			free(line);
			continue;
		}
		match[0].sp = match[0].ep = 0;
		if(regexec(lirp, line, match, MSZ)){
			gotanything = 1;
			if(recentnn == nil || recentlin == nil){
				free(line);
				continue;
			}
			recentlin = (linode*)malloc(sizeof(linode));
			recentlin->value = copymatch(1);
			recentlin->index = atoi(recentlin->value);
			free(recentlin->value);
			recentlin->value = nil;
			if(recentln){
				if(dup = avllookup(recentln->litree, recentlin, 0)){
					freelinode(recentlin);
					recentlin = (linode*) dup;
				} else {
					freelinode(recentlin);
					recentlin = nil;
				}
			}
			free(line);
			continue;
		}

		free(line);

	}
	if(recentnn){
		if(recentln){
			if(recentlin){
				printlinode(recentlin, bioo, 0); 
			} else {
				printlnode(recentln, bioo, 0);
				Bprint(bioo, "!\n");
			}
		} else if(recentkvn){
			printkval(recentkvn, bioo, 1);
		} else if(triedtofindlist){
			if(wantlists){
				walk(recentnn->ltree, bioo, printlname, 0);
				Bprint(bioo, "!\n");
			} else if (wantkeys){
				walk(recentnn->kvtree, bioo, printkey, 0);
				Bprint(bioo, "!\n");
			}else {
				Bprint(bioo, "!\n");
			}
	
		} else {
			printndtlnode(recentnn, bioo, 0);
			Bprint(bioo, "!\n");
		}
	} else {
		if(gotanything==0){
			walk(tree, bioo, printndtlnames, 0);
			Bprint(bioo, "!\n");
		} else {
			Bprint(bioo, "!\n");
			fprint(2, "lookup item not found\n");
		}
	}

	free(cmrp);
	free(whrp);
	free(nmrp);
	free(klrp);
	free(lirp);
	free(eofrp);
}

void 
ndtlparse(Biobuf * bio){

	//Biobuf * debug = Bfdopen(2, OWRITE);

	Reprog * cmrp = regcomp(cmrx);
	Reprog * whrp = regcomp(whrx);
	Reprog * nmrp = regcomp(nmrx);
	Reprog * kvrp = regcomp(kvrx);
	Reprog * lnrp = regcomp(lnrx);
	Reprog * lirp = regcomp(lirx);
	Reprog * eofrp = regcomp(eofrx);


	Avl  * dup;
	char * line;
	ndtlnode * recentnn = nil;
	kvnode   * recentkvn;
	lnode    * recentln = nil;
	linode   * recentlin;
	int listitemcount = 0;
	
	
	while(line = Brdstr(bio, '\n', 1)){

		match[0].sp = match[0].ep = 0;
		if(regexec(cmrp, line, match, MSZ)){
			free(line);
			continue;
		}
		match[0].sp = match[0].ep = 0;
		if(regexec(whrp, line, match, MSZ)){
			free(line);
			continue;
		}

		match[0].sp = match[0].ep = 0;
		if(regexec(nmrp, line, match, MSZ)){
			recentnn = (ndtlnode*)malloc(sizeof(ndtlnode));
			recentnn->name = copymatch(1);
			recentnn->kvtree = avlcreate(kvcmp);
			recentnn->ltree = avlcreate(lcmp);
			if(dup = avllookup(tree, recentnn, 0)){
				freendtlnode(recentnn);
				recentnn = (ndtlnode*)dup;
			} else {
				if(dup = avlinsert(tree, recentnn))
					freendtlnode(dup); //shouldn't happen
			}
			free(line);
			continue;
		}
		match[0].sp = match[0].ep = 0;
		if(regexec(kvrp, line, match, MSZ)){
			recentkvn = (kvnode*)malloc(sizeof(kvnode));
			recentkvn->key = copymatch(1);
			recentkvn->val = copymatch(2);
			if(dup = avlinsert(recentnn->kvtree, recentkvn))
				freekvnode(dup);
			free(line);
			continue;
		}
		match[0].sp = match[0].ep = 0;
		if(regexec(lnrp, line, match, MSZ)){
			recentln = (lnode*)malloc(sizeof(lnode));
			recentln->name = copymatch(1);
			recentln->litree = avlcreate(licmp);
			listitemcount = 0;
			if(dup = avlinsert(recentnn->ltree, recentln))
				freelnode(dup);
			free(line);
			continue;
		}
		match[0].sp = match[0].ep = 0;
		if(regexec(lirp, line, match, MSZ)){
			recentlin = (linode*)malloc(sizeof(linode));
			recentlin->index = ++listitemcount;
			recentlin->value = copymatch(1);
			if(recentln){
				if(dup = avlinsert(recentln->litree, recentlin))
					freelinode(dup);	
			}
			free(line);
			continue;
		}
		match[0].sp = match[0].ep = 0;
		if(regexec(eofrp, line, match, MSZ)){
		//	print("got to end\n");
			free(line);
			break;
		}
		free(line);

	}

	free(cmrp);
	free(whrp);
	free(nmrp);
	free(kvrp);
	free(lnrp);
	free(lirp);
	free(eofrp);
}

char * ndtlfindkey;
char * ndtlfindval;
char * ndtlfindce;
void ndtlfindKEYVAL(Avl* n, Biobuf * o, int){
	kvnode * N = (kvnode *)n;
	if(mcuistrcmp(N->key, ndtlfindkey) == 0)
		if(mcuistrcmp(N->val, ndtlfindval) == 0)
			Bprint(o,"%s\n",ndtlfindce);
}
void ndtlfindENTRY(Avl* n, Biobuf * o, int d){
	ndtlnode * N = (ndtlnode*)n;
	ndtlfindce = N->name;
	walk(N->kvtree, o, ndtlfindKEYVAL, d);
}
void
ndtlfind(Biobuf * bioi, Biobuf * bioo) {

	Reprog * cmrp = regcomp(cmrx);
	Reprog * whrp = regcomp(whrx);
	Reprog * kvrp = regcomp(kvarx);
	Reprog * eofrp = regcomp(eofrx);

	char * line;

	while(line = Brdstr(bioi, '\n', 1)){

		match[0].sp = match[0].ep = 0;
		if(regexec(cmrp, line, match, MSZ)){
			free(line);
			continue;
		}
		match[0].sp = match[0].ep = 0;
		if(regexec(whrp, line, match, MSZ)){
			free(line);
			continue;
		}
		match[0].sp = match[0].ep = 0;
		if(regexec(eofrp, line, match, MSZ)){
		//	print("got to end\n");
			free(line);
			break;
		}
		match[0].sp = match[0].ep = 0;
		if(regexec(kvrp, line, match, MSZ)){
			ndtlfindkey = copymatch(1);
			ndtlfindval = copymatch(2);
			walk(tree, bioo, ndtlfindENTRY, 1);
			free(ndtlfindkey);
			free(ndtlfindval);
			free(line);
			continue;
		}
		free(line);
	}
	Bprint(bioo, "!\n");

	free(cmrp);
	free(whrp);
	free(kvrp);
	free(eofrp);
}



/*****************************************************
//the following is getting implemented elsewhere, but i want to keep what's here for the near future.
void
processcommand(Biobuf * bioc, Biobuf * biod){
	Reprog * cmdlookuprp = regcomp(cmdlookuprx);
	Reprog * cmddeleterp = regcomp(cmddeleterx);
	Reprog * cmdinsertrp = regcomp(cmdinsertrx);

	char * line;

	line = Brdstr(bioc, '\n', 1);
	if(line){
		match[0].sp = match[0].ep = 0;
		if(regexec(cmdlookuprp, line, match, MSZ)){
	
			return;
		}
		match[0].sp = match[0].ep = 0;
		if(regexec(cmddeleterp, line, match, MSZ)){
			return;
		}
		match[0].sp = match[0].ep = 0;
		if(regexec(cmddeleterp, line, match, MSZ)){

			return;
		}
		Bprint(biod, "ERROR");
		fprint(2, "ERROR: %s - unknown command", line);

	free(cmdlookuprp);
	free(cmddeleterp);
	free(cmdinsertrp);
	}
}


void
ndtltest( int , char ** )
{
	char * file=0;
	Biobuf * stream;
	Avltree * tree;
	ARGBEGIN {

		case 'f':
				file=ARGF();
				break;
		default:
				break;
	} ARGEND

	if (file){
		//print("file %s\n", file);
		stream = Bopen(file, OREAD);
	}else{
		//print("stdin\n");
		stream = Bfdopen( 0, OREAD);
	}
	Avltree * tree = avlcreate(ndtlcmp);
	ndtlparse(stream);
	walk(tree, printndtlnode, 0);
}

void
main( int, char **){
	int dffd = create (datafile, ORDWR, 0666);
	int cffd = create (cmdfile, ORDWR, 0666);
	int dsfd = create (datasrv, ORDWR, 0666);
	int csfd = create (cmdsrv, ORDWR, 0666);
	Biobuf * datastream = Bfdopen( dffd, ORDWR);
	Biobuf * cmdstream = Bfdopen( cffd, OREAD);
	fprint(dsfd, "%d", dffd);
	fprint(csfd, "%d", csfd);
	tree = avlcreate(ndtlcmp);
	
	while(sleep 100){
	

	}
	
}
***************************************************/
	
